/*{
	"GUID":"81D46CE2-7D13-4a85-9EE1-DFEE0C44FE3D",
	"INPUTS":[
		{
			"TYPE":"image",
			"FILE":"TuneMap_DanGui.bmp"
		},
		{
			"TYPE":"image",
			"FILE":"ColorTuneCircle01.png"
		}
	]
}*/

#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc).zyxw;
}

vec4 INPUT(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, tc).zyxw;
}


//Do overlay using the golden code from gles orange book
vec4 DoOverlay(vec4 base, vec4 blend)
{
    vec4 result;
    vec4 lumCoeff = (vec4)(0.0721f, 0.7154f, 0.2125f, 0.0f);
    vec4 white = (vec4)(1.0f, 1.0f, 1.0f, 1.0f);
    
    float luminance = dot(base, lumCoeff);
    if (luminance < 0.45f)
        result = 2.0f * blend * base;
    else if (luminance > 0.55f)
        result = white - 2.0f * (white - blend) * (white - base);
    else 
    {
        vec4 result1 = 2.0f * blend * base;
        vec4 result2 = white - 2.0f * (white - blend) * (white - base);
        result = mix(result1, result2, (vec4)( (luminance - 0.45f) * 10.0f) );
    }
    
    return result;
}

float WS_DoOverlayPerChannel(float baseVal, float blendVal)
{
    float result;
    
    if(baseVal < 0.5f)
    {
        result = 2.0f * baseVal * blendVal;
    }
    else
        result = 1.0f - 2.0f * (1.0f - baseVal) * (1.0 - blendVal);
    
    return result;
}


__kernel void MAIN(__read_only image2d_t input1, 
	__read_only image2d_t input2, 
	__read_only image2d_t input3, 
	__write_only image2d_t dest_data,
	__global FilterParam* param,
	int alpha)
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	float2 iResolution = (float2)(W,H);
	vec2 tc = (fragCoord + (float2)(0.5f)) / (float2)(W,H);
	
	const int u_blendFlags0 = 1;
	const int u_blendFlags1 = 1;
	const int u_blendFlags2 = 0;
	const int u_blendFlags3 = 0;
	const int u_blendFlags4 = 0;
	const float u_blendFlags5 = 0.0f;

    vec4 tuneColor = INPUTSRC(input1, param, tc);
    vec4 orig = tuneColor;
	
    if(u_blendFlags0 > 0)
    {
		tuneColor.x = INPUT(input2, (vec2)(tuneColor.x, .16666f)).x;
		tuneColor.y = INPUT(input2, (vec2)(tuneColor.y, .5f)).y;
		tuneColor.z = INPUT(input2, (vec2)(tuneColor.z, .83333f)).z;
    }
    
    int SumFlag = u_blendFlags1 + u_blendFlags2 + u_blendFlags3 + u_blendFlags4;
    
    if(SumFlag > 0)
    {
        vec4 blendColor = INPUT(input3, tc);
        vec4 srcVal = tuneColor;
        
    #if 1
        if(u_blendFlags1 > 0) //Do overlay 
        {
            tuneColor.x = WS_DoOverlayPerChannel(tuneColor.x, blendColor.x);
            tuneColor.y = WS_DoOverlayPerChannel(tuneColor.y, blendColor.y); 
            tuneColor.z = WS_DoOverlayPerChannel(tuneColor.z, blendColor.z); 
        }
    #else
        if(u_blendFlags1 > 0) //Do overlay 
            tuneColor = DoOverlay(tuneColor, blendColor);
    #endif
	
	 
        if(u_blendFlags2 > 0) //Do multiply
            tuneColor = tuneColor * blendColor;
        
        if(u_blendFlags3 > 0) //Do screen
            tuneColor = 1.0f - ((1.0f - blendColor) * (1.0f - tuneColor));
        
        if(u_blendFlags4 > 0) //Do blend
            tuneColor = mix(srcVal, tuneColor, (float4)(u_blendFlags5) );
			
    }
     float4 outputCol =  mix((vec4)(tuneColor.zyx, orig.w), orig.zyxw, (vec4)(1.0f - (float)alpha/100.0f)); 
	 write_imagef(dest_data, coordinate, (vec4)(outputCol.xyz, 1.0f));
}
